import DynamicPage from "@/Views/DynamicPages/DynamicPage";
import { generateDynamicMeta } from "@/lib/seo/generateDynamicMeta";

export async function generateMetadata({ params }) {
  const param = await params;
  let slug = param.slug;

  if (Array.isArray(slug)) {
    slug = slug.join("/");
  }

  if (
    !slug ||
    slug.startsWith("_next") ||
    slug.startsWith("__nextjs") ||
    slug.startsWith(".well-known") ||
    slug.includes(".ico") ||
    slug.includes(".jpg") ||
    slug.includes(".png") ||
    slug.includes(".webp") ||
    slug.includes(".css") ||
    slug.includes(".js") ||
    slug.includes(".map")
  ) {
    return {
      title: "Selvakumar Jewellary",
      description: "Discover exquisite jewelry at Selvakumar Jewellary",
    };
  }
  return await generateDynamicMeta(slug);
}

const page = async ({ params }) => {
  const param = await params;
  const slug = param.slug;

  return <DynamicPage slug={slug} />;
};

export default page;
